/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class DownloadHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadHelper.class);
    private final String url;
    private final String fileCacheDir;
    private final File file;

    public DownloadHelper(String url, String fileCacheDir) {
        this.url = url;
        this.fileCacheDir = fileCacheDir;
        this.file = this.createFile(UriComponentsBuilder.fromUriString((String)url).build().getPathSegments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File download() {
        File file;
        FileOutputStream os;
        InputStream inputStream;
        HttpURLConnection urlConnection;
        block15: {
            File file2;
            block14: {
                urlConnection = null;
                inputStream = null;
                os = null;
                try {
                    int len;
                    urlConnection = (HttpURLConnection)new URL(this.url).openConnection();
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode != 200) {
                        File file3 = null;
                        return file3;
                    }
                    inputStream = urlConnection.getInputStream();
                    long contentLength = urlConnection.getHeaderFieldLong("Content-Length", -1L);
                    if (this.exists(contentLength)) {
                        file2 = this.file;
                        IOUtils.closeQuietly((InputStream)inputStream);
                        break block14;
                    }
                    this.createFileIfNecessaryDelete();
                    long start = System.currentTimeMillis();
                    if (LOGGER.isInfoEnabled()) {
                        BigDecimal mb = this.toMb(contentLength);
                        LOGGER.info("{} Starting download, The content length is {} MB...", (Object)this.url, (Object)mb);
                    }
                    float step = contentLength / 100L;
                    int cache = 0xA00000;
                    byte[] buffer = new byte[contentLength > (long)cache ? cache : (int)contentLength];
                    os = new FileOutputStream(this.file, true);
                    int i = 1;
                    while ((len = inputStream.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                        long size = os.getChannel().size();
                        if (!(step >= 1.0f) || !((float)size >= step * (float)i)) continue;
                        LOGGER.info("Downloading progress\t{}%\t{} MB", (Object)i++, (Object)this.toMb(size));
                    }
                    os.flush();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("{} Finished in {} ms!", (Object)this.url, (Object)(System.currentTimeMillis() - start));
                    }
                    file = this.file;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    break block15;
                }
                catch (Exception e) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("download: ", (Throwable)e);
                    }
                    File file4 = null;
                    return file4;
                }
            }
            IOUtils.closeQuietly(os);
            if (null == urlConnection) return file2;
            urlConnection.disconnect();
            return file2;
        }
        IOUtils.closeQuietly((OutputStream)os);
        if (null == urlConnection) return file;
        urlConnection.disconnect();
        return file;
        finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(os);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }

    private boolean exists(long contentLength) {
        long length = this.file.length();
        return contentLength == length;
    }

    private File createFile(List<String> pathSegments) {
        StringBuilder s = new StringBuilder();
        s.append(this.fileCacheDir);
        for (String pathSegment : pathSegments) {
            s.append(File.separator).append(pathSegment);
        }
        File file = new File(s.toString());
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new RuntimeException("mkdir occur ex: " + parentFile);
        }
        if (!file.exists()) {
            this.createFile(file);
        }
        return file;
    }

    private void createFileIfNecessaryDelete() {
        if (this.file.exists()) {
            if (!this.file.delete()) {
                throw new RuntimeException("Cannot delete file: " + this.file);
            }
            LOGGER.info("Delete file: {}", (Object)this.file);
            this.createFile(this.file);
        }
    }

    private void createFile(File file) {
        try {
            if (!file.createNewFile()) {
                throw new RuntimeException("Cannot create file: " + file);
            }
            LOGGER.info("Created file: {}", (Object)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BigDecimal toMb(long size) {
        return new BigDecimal(size).divide(new BigDecimal(0x100000), 2, RoundingMode.HALF_UP);
    }
}

