/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.scheduler.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] download(String url) {
        byte[] byArray;
        ByteArrayOutputStream out;
        InputStream inputStream;
        HttpURLConnection urlConnection;
        block13: {
            byte[] byArray2;
            block12: {
                urlConnection = null;
                inputStream = null;
                out = null;
                try {
                    int len;
                    urlConnection = (HttpURLConnection)new URL(url).openConnection();
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode != 200) {
                        byArray2 = new byte[]{};
                        IOUtils.closeQuietly(out);
                        break block12;
                    }
                    inputStream = urlConnection.getInputStream();
                    int length = urlConnection.getHeaderFieldInt("Content-Length", -1);
                    int available = length > 0 ? length : inputStream.available();
                    long start = System.currentTimeMillis();
                    if (LOGGER.isInfoEnabled()) {
                        BigDecimal mb = FileHelper.toMb(available);
                        LOGGER.info("{} Starting download, The content length is {} MB...", (Object)url, (Object)mb);
                    }
                    float step = available / 100;
                    out = new ByteArrayOutputStream(available);
                    byte[] buffer = new byte[0xA00000];
                    int i = 1;
                    while ((len = inputStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                        int size = out.size();
                        if (!(step >= 1.0f) || !((float)size >= step * (float)i)) continue;
                        LOGGER.info("Downloading progress\t{}%\t{} MB", (Object)i++, (Object)FileHelper.toMb(size));
                    }
                    out.flush();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("{} Finished in {} ms!", (Object)url, (Object)(System.currentTimeMillis() - start));
                    }
                    byArray = out.toByteArray();
                    IOUtils.closeQuietly((OutputStream)out);
                    break block13;
                }
                catch (Exception e) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("download: ", (Throwable)e);
                    }
                    byte[] byArray3 = null;
                    return byArray3;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            if (null == urlConnection) return byArray2;
            urlConnection.disconnect();
            return byArray2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (null == urlConnection) return byArray;
        urlConnection.disconnect();
        return byArray;
        finally {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }

    private static BigDecimal toMb(int size) {
        return new BigDecimal(size).divide(new BigDecimal(0x100000), 2, RoundingMode.HALF_UP);
    }
}

