package com.bxm.pay.facade.enums;

import com.bxm.pay.facade.model.Order;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * 订单状态
 *
 * @author zhangdong
 */
@Getter
@AllArgsConstructor
public enum OrderStatusEnum {

    /**
     * 待支付
     */
    WAIT_PAY(Order.STATUS_PRE_PAY, "待支付", Lists.newArrayList(Order.STATUS_CLOSE_PAY, Order.STATUS_SUCCESS_PAY)),
    /**
     * 关闭支付
     */
    CLOSE_PAY(Order.STATUS_CLOSE_PAY, "关闭支付", Lists.newArrayList()),
    /**
     * 已支付
     */
    SUCCESS_PAY(Order.STATUS_SUCCESS_PAY, "已支付", Lists.newArrayList(Order.STATUE_REFUND_APPLY)),
    /**
     * 退款中
     */
    REFUNDING(Order.STATUE_REFUND_APPLY, "退款中", Lists.newArrayList(Order.STATUS_REFUND_PAY, Order.STATUE_REFUND_ERROR,Order.STATUE_REFUND_APPLY)),
    /**
     * 退款完成
     */
    SUCCESS_REFUND(Order.STATUS_REFUND_PAY, "退款完成", Lists.newArrayList()),
    /**
     * 退款失败
     */
    FAIL_REFUND(Order.STATUE_REFUND_ERROR, "退款失败", Lists.newArrayList(Order.STATUE_REFUND_APPLY)),
    ;

    private final Byte status;
    private final String desc;
    private final List<Byte> nextStatusList;

    public static boolean allowStatusChange(Byte current, Byte next) {
        for (OrderStatusEnum x : OrderStatusEnum.values()) {
            if (x.status.equals(current)) {
                return x.nextStatusList.contains(next);
            }
        }
        return false;
    }


}
