package com.bxm.pay.facade.enums;

import com.bxm.pay.facade.model.Order;
import org.apache.commons.lang.StringUtils;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/10/17 16:22
 */
public enum  PayStatusEnum {

    /**
     * 待支付
     */
    WAIT_BUYER_PAY(Order.STATUS_PRE_PAY,"WAIT_BUYER_PAY"),
    /**
     * 关闭
     */
    TRADE_CLOSED(Order.STATUS_CLOSE_PAY,"TRADE_CLOSED"),
    /**
     * 成功
     */
    TRADE_SUCCESS(Order.STATUS_SUCCESS_PAY,"TRADE_SUCCESS"),
    /**
     * 等待卖家收款
     */
    TRADE_PENDING(Order.STATUS_PENDING_PAY,"STATUS_PENDING_PAY"),
    /**
     * 完成，不可以做任何更改
     */
    TRADE_FINISHED(Order.STATUS_FINISHED_PAY,"STATUS_FINISHED_PAY");


    private byte code;
    private String name;

    PayStatusEnum(byte code,String name){
        this.code = code;
        this.name = name;
    }

    public static byte getCodeByName(String name){
        if (StringUtils.isNotBlank(name)){
            for (PayStatusEnum statusEnum:PayStatusEnum.values()) {
                if (statusEnum.name.equals(name)){
                    return statusEnum.code;
                }
            }
        }
        return WAIT_BUYER_PAY.code;
    }

}
