package com.bxm.pay.facade.model;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/10/15 11:13
 */
@Data
public class Order implements Serializable {
    private static final long serialVersionUID = 5898421344661777984L;
    /**
     * 状态：-1未找到，0未支付，1已支付,3已关闭,已支付待收款，5已完成,6退款成功,7退款已申请,8退款异常
     */
    public static final byte STATUS_PRE_NULL = -1 ;
    public static final byte STATUS_PRE_PAY = 0 ;
    public static final byte STATUS_SUCCESS_PAY = 1 ;
    public static final byte STATUS_CLOSE_PAY = 3 ;
    public static final byte STATUS_PENDING_PAY = 4 ;
    public static final byte STATUS_FINISHED_PAY = 5 ;
    public static final byte STATUS_REFUND_PAY = 6;
    public static final byte STATUE_REFUND_APPLY = 7;
    public static final byte STATUE_REFUND_ERROR = 8;

    /**
     * 客户端类型，0：h5，1：app，2：微信，3：QQ, 4:PC , 5:支付宝
     */
    public static final byte CLIENT_TYPE_H5 = 0 ;
    public static final byte CLIENT_TYPE_APP = 1 ;
    public static final byte CLIENT_TYPE_WECHAT = 2 ;
    public static final byte CLIENT_TYPE_QQ = 3 ;
    public static final byte CLIENT_TYPE_PC = 4 ;
    public static final byte CLIENT_TYPE_ALI = 5;

    /**
     * 支付渠道 1支付宝支付，2微信支付
     */
    public static final byte PAY_TYPE_ALI = 1 ;
    public static final byte PAY_TYPE_WECHAT = 2 ;

    /**
     * 订单号 调用业务生成
     */
    @ValidateNotNull
    private String orderNum;
    /**
     * 主订单号
     */
    private String masterOrderNum;

    /**
     * 订单id 支付项目生成
     */
    private String orderId;

    /**
     * 交易号 支付商交易号
     */
    private String tradeNum;

    /**
     * 金额（单位：元）
     */
    @ValidateNotNull
    private BigDecimal amount;

    /**
     * 支付渠道 1支付宝支付，2微信支付
     */
    @ValidateNotNull
    private Byte payType;

    /**
     * 状态：0未支付，1已完成,3已关闭
     */
    private Byte status;

    /**
     * 业务 1 征信
     */
    @ValidateNotNull
    private Byte business = 1;

    /**
     * 主题 如:广告-互动业务
     */
    @ValidateNotNull
    private String subject;

    /**
     *微信id
     */
    private String openId;

    /**
     * 说明
     */
    private String body;

    /**
     * 通知地址
     */
    @ValidateNotNull
    private String notifyUrl;

    private Integer payConfigId;

    /**
     * 客户端类型，0：h5，1：app，2：微信，3：QQ, 4:PC
     */
    @ValidateNotNull
    private Byte clientType;

    /**
     * 支付客户端ip
     */
    private String clientIp;

    private String requestHost;
    /**
     * 退款金额
     */
    private BigDecimal refundAmount;
    /**
     * 退款通知链接
     */
    private String refundNotifyUrl;
    /**
     * 跳转链接
     */
    private String reboundUrl;
    /**
     * 是否是退款通知
     */
    private Boolean refundNotify;
    /**
     * 子订单信息
     */
    private List<Order> subOrders;
    /**
     * 认证code
     */
    private String authCode;
    /**
     * 微信appID
     */
    private String wxAppId;

    public String getRequestHost() {
        return requestHost;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Byte getClientType() {
        return clientType;
    }

    public void setClientType(Byte clientType) {
        this.clientType = clientType;
    }

    public Integer getPayConfigId() {
        return payConfigId;
    }

    public void setPayConfigId(Integer payConfigId) {
        this.payConfigId = payConfigId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Byte getPayType() {
        return payType;
    }

    public void setPayType(Byte payType) {
        this.payType = payType;
    }

    public Byte getBusiness() {
        return business;
    }

    public void setBusiness(Byte business) {
        this.business = business;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getTradeNum() {
        return tradeNum;
    }

    public void setTradeNum(String tradeNum) {
        this.tradeNum = tradeNum;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
}
