package com.bxm.pay.facade.model;

import com.bxm.pay.facade.enums.CallbackTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author zhangdong
 * @date 2023/12/20
 */
@Data
@Accessors(chain = true)
public class OrderCallbackResult implements Serializable {

    /**
     * 订单id
     */
    private String orderId;
    /**
     * 交易单号
     */
    private String tradeNum;
    /**
     * 订单退款单号
     */
    private String orderRefundNum;
    /**
     * 回调类型 支付回调 退款回调
     */
    private Integer callbackType;
    /**
     * 订单状态
     */
    private Byte orderStatus;
    /**
     * 扩展参数
     */
    protected Object ext;

    public boolean isPayCallback(){
        return CallbackTypeEnum.PAY_CALLBACK.getCode().equals(callbackType);
    }

    public boolean isRefundCallback(){
        return CallbackTypeEnum.REFUND_CALLBACK.getCode().equals(callbackType);
    }


}
