package com.bxm.pay.facade.model;

import com.bxm.pay.facade.constants.TransferConstants;

/**
 * 转账信息
 * @author tangx
 * @date 2021/7/20 18:50
 */
public class TransferDTO {

    /**
     * 外部订单号
     */
    private String outOrderNum;

    /**
     * uid
     */
    private String outUid;

    /**
     * 转账金额
     */
    private String transAmount;

    /**
     * 转账账号
     */
    private String account;

    /**
     * 姓名
     */
    private String name;

    /**
     * 转账备注
     */
    private String remark;

    /**
     * 转账标题
     */
    private String title;

    /**
     * 转账业务类型 1.互动活动 2.sdk活动
     */
    private Byte businessType;

    /**
     * 支付宝用户id
     * @return
     */
    private String userId;

    /**
     * 埋点 类型 正常买量:normal  脚本打款：script
     */
    private String way;

    /**
     * 如果是内部接口打款  记录筛选时间  格式 2022-01-01 00:00:00,2022-01-02 00:00:00
     */
    private String period;

    public String getWay() {
        return way;
    }

    public void setWay(String way) {
        this.way = way;
    }

    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public Byte getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Byte businessType) {
        this.businessType = businessType;
    }

    public String getTransAmount() {
        return transAmount;
    }

    public void setTransAmount(String transAmount) {
        this.transAmount = transAmount;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOutOrderNum() {
        return outOrderNum;
    }

    public void setOutOrderNum(String outOrderNum) {
        this.outOrderNum = outOrderNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOutUid() {
        return outUid;
    }

    public void setOutUid(String outUid) {
        this.outUid = outUid;
    }

    public boolean isSdkActivity() {
        return businessType != null && businessType.equals(TransferConstants.SDK_ACTIVITY);
    }
    public boolean isNotSdkActivity() {
        return !isSdkActivity();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
