package com.bxm.pay.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: pf.w
 * @Date: 2022/10/20 13:37
 */
@Data
public class TransferOrderBean implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 转账交易订单号
     */
    private String tradeNum;

    /**
     * 支付宝支付资金流水号
     */
    private String payFundOrderId;

    /**
     * 订单号
     */
    private String outOrderNum;

    private String outUid;

    /**
     * 用户姓名
     */
    private String name;

    /**
     * 转账金额 元
     */
    private BigDecimal transAmount;

    /**
     * 发放账号
     */
    private String account;

    /**
     * 转账业务的标题
     */
    private String title;

    /**
     * 转账备注
     */
    private String remark;

    /**
     * 转账渠道 1.支付宝
     */
    private Byte transferChannel;

    /**
     * 转账状态 0.失败 1.成功
     */
    private Byte transferStatus;

    private String responseMsg;

    private String userId;

    private Date createTime;

    private Date updateTime;


    /**
     * 转账业务类型 1.互动活动 2.sdk活动
     */
    private Byte businessType;
}
