package com.bxm.promotion.facade.service;


import com.bxm.promotion.facade.constants.PromotionConstants;
import com.bxm.promotion.facade.model.UserActionModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;


@FeignClient(name = PromotionConstants.SERVER_NAME)
public interface PromotionFacadeService {


    /**
     * 注册/充值/消费/后续调用
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/facade/addBdRecord")
    public ResponseEntity<Boolean> addBdRecord(@RequestBody UserActionModel userActionModel);

    /**
     * 增加奖励记录
     */
    @PostMapping(value = "/rewardRecord/add")
    ResponseEntity<Boolean> addReward(@RequestBody @Validated UserActionModel userActionModel);

}