package com.bxm.shop;

import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;

/**
 *
 * @author hcmony
 * @since V1.0.0, 2018/10/31 14:30
 */
@SpringBootApplication
@EnableDiscoveryClient
@EnableFeignClients({"com.bxm.shop.facade"})
public class ShopsApiApplication {

	public static void main(String[] args) {
		SpringApplication application = new SpringApplication(com.bxm.shop.ShopsApiApplication.class);
		application.addListeners(new SpringBootEnvironmentListener());
		application.run(args);
	}
}
