package com.bxm.shop.controller;

import com.bxm.shop.facade.FeedbackService;
import com.bxm.shop.facade.model.FeedbackVo;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2018/11/13
 */
@RequestMapping("/feedback")
@RestController
@Slf4j
public class FeedbackController {

    @Resource
    private FeedbackService feedbackService;

    @PutMapping("/submit")
    public ResultModel submit(@RequestBody FeedbackVo feedbackVo){
        return feedbackService.submit(feedbackVo);
    }

}
