package com.bxm.shop.controller;

import com.bxm.shop.facade.GoodsService;
import com.bxm.shop.facade.model.GoodDetailVo;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2018/11/14
 */
@RequestMapping("/goodDetail")
@RestController
public class GoodDetailController {

    @Resource
    private GoodsService goodsService;

    @GetMapping("/baseInfo")
    public ResultModel<GoodDetailVo> getBaseInfo(String goodId){
        return goodsService.getDetail(goodId);
    }
}
