package com.bxm.shop.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.GoodsService;
import com.bxm.shop.facade.model.Banner;
import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.facade.model.TagVo;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 首页
 * @author yirenjie
 * createDate:  2018/11/8
 */
@RestController
@RequestMapping("/home")
@Slf4j
public class HomeController {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private GoodsService goodsService;

    @GetMapping("/getTags")
    public ResultModel<List<TagVo>> getTags(){
        return goodsService.getTags();
    }

    @GetMapping("/getBanners")
    public ResultModel<List<Banner>> getBanners(){
        ResultModel<List<Banner>> result = new EnhanceResultModel<>();
        String json = stringRedisTemplate.opsForValue().get(RedisConstants.BANNER_CONFIG_KEY);
        if (StringUtils.isNotBlank(json)) {
            result.setReturnValue(JSONObject.parseArray(json, Banner.class));
            return result;
        }
        result = new EnhanceResultModel<List<Banner>>(ResponseCodeType.DATA_ANOMALY);
        log.error("banner配置为空,redisKey={}", RedisConstants.BANNER_CONFIG_KEY);
        return result;
    }

    @GetMapping("/getGoodsList")
    public ResultModel<List<GoodVo>> getGoodsList(GoodsQueryRo goodsQueryRo){
        return goodsService.getGoodsList(goodsQueryRo);
    }

}
