package com.bxm.shop.controller;

import com.bxm.shop.facade.GoodsService;
import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/11/12
 */
@RestController
@RequestMapping("/search")
public class SearchController {

    @Resource
    private GoodsService goodsService;

    @GetMapping("/goodsList")
    public ResultModel<List<GoodVo>> goodsList(GoodsQueryRo goodsQueryRo) {
        return goodsService.getGoodsList(goodsQueryRo);
    }


}
