package com.bxm.shop.common.exception;


import com.bxm.warcar.utils.response.ResultModel;
import lombok.ToString;

/**
 * @author yirenjie
 * createDate:  2018/7/12
 */
@ToString
public class EnhanceResultModel<T> extends ResultModel<T> {

    public EnhanceResultModel() {
        setSuccessed(true);
    }

    public EnhanceResultModel(T returnValue) {
        setSuccessed(true);
        setReturnValue(returnValue);
    }

    public EnhanceResultModel(ResponseCodeType codeType, String... msg) {
        setSuccessed(false);
        setErrorCode(codeType.getErrorCode());
        setErrorDesc(msg == null ? codeType.getErrorMsg() : String.format(codeType.getErrorMsg(), msg));
    }

    public EnhanceResultModel(Exception e) {
        setSuccessed(false);
        setErrorCode(ResponseCodeType.SYSTEM_ERROR.getErrorCode());
        setErrorDesc(e.getMessage());
    }

}
