package com.bxm.shop.common.exception;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author yirenjie
 * createDate:  2018/11/8
 */
public final class RedisConstants {

    private RedisConstants(){}


    public static final String GOODS_POOL_KEY = "MINIPROGRAM:GOODSPOOL:LIST:2"; // 商品池redisKey
    public static final String TAG_CONFIG_KEY = "MINIPROGRAM:TAG:CONFIG"; // 标签配置
    public static final String BANNER_CONFIG_KEY = "MINIPROGRAM:BANNER:LIST"; // banner配置
    public static final String REBATE_CONFIG_KEY = "MINIPROGRAM:REBATE:LIST:%s"; // 返利配置,根据商品id; 占位符0为默认配置
    public static final String POP_LIST_KEY = "MINIPROGRAM:POP:LIST"; // pop模拟数据key


    public static class User{

        /**
         * SESSION时长 1小时
         */
        public static final Integer SESSION_TIME = 60 * 60 * 60 ;

        /**
         * 用户信息 HASH
         * OPENID : USERDAO
         * @return
         */
        public static KeyGenerator getUserInfo(){
            return () -> KeyBuilder.build("MINIPROGRAM", "USER", "INFO");
        }

        /**
         * SESSION信息 HASH
         * sessionId :  openid
         * @return
         */
        public static KeyGenerator getSessionId(String openid,String sessionId){
            return () -> KeyBuilder.build("MINIPROGRAM", "USER", "SESSIONID",openid,sessionId);
        }

    }
}
