package com.bxm.shop.common.exception;


/**
 * api系统错误码
 * Created by yirenjie
 *
 */
public enum ResponseCodeType {

//    SUCCESS("00000000", "成功"),
    HANDLING("00000001", "正在处理中，请您耐心等待"),
    SYSTEM_ERROR("10009999", "系统异常，请稍后再试"),
    OPERATION_NOT_EXECUTED("10009998", "操作未执行"),
    OPERATION_NOT_SUPPORTED("10009997", "操作不支持"),
    DATA_ANOMALY("10009996", "数据异常"),
    PARAM_ILLEGAL("10009995", "参数非法%s");


    /**
     * 返回码
     */
    private String errorCode;

    /**
     * 返回描述
     */
    private String errorMsg;

    ResponseCodeType(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

//    public static boolean isSuccess(String resultCode) {
//        return SUCCESS.getErrorCode().equals(resultCode);
//    }

    public static boolean isHandling(String resultCode) {
        return HANDLING.getErrorCode().equals(resultCode);
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }
}
