package com.bxm.shop.common.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

/**
 * @author yirenjie
 * createDate:  2018/7/12
 */
public class ShopsException extends RuntimeException implements Serializable {
    private static final long serialVersionUID = 1L;

    private ResponseCodeType codeType;
    private Throwable cause;                              // 异常
    private String errorCode;                          // 错误code

    public ShopsException(ResponseCodeType codeType, String... msg) {
        this(codeType.getErrorCode(), msg == null ? codeType.getErrorMsg() : String.format(codeType.getErrorMsg(), msg));
        this.codeType = codeType;
    }

    public ResponseCodeType getCodeType() {
        return codeType;
    }

    public ShopsException(String errorMsg) {
        this("", errorMsg);
    }

    public ShopsException(Throwable cause) {
        this(cause, ResponseCodeType.SYSTEM_ERROR.getErrorCode(), ResponseCodeType.SYSTEM_ERROR.getErrorMsg());
    }

    public ShopsException(String errorCode, String errorMsg) {
        this(null, errorCode, errorMsg);
    }

    public ShopsException(Throwable cause, String errorCode, String errorMsg) {
        super(errorMsg);
        this.cause = cause;
        this.errorCode = errorCode;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (null == getCause()) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            getCause().printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        if (null == getCause()) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            getCause().printStackTrace(pw);
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    @Override
    public String getMessage() {
        if (getCause() == null) {
            return super.getMessage();
        }
        return super.getMessage() + getCause().getMessage();
    }

    public String getErrorCode() {
        return errorCode;
    }

}
