package com.bxm.shop.common.enums;

/**
 * 收益类型
 * @author bcc
 */
public enum ProfitTypeEnum {

    PURCHASE("purchase","自购返利"),

    SHARE("share","分享返利"),

    PARENT("parent","上级返利"),

    GRANDPARENT("grandparent","上上级返利");

    private String code;

    private String label;

    ProfitTypeEnum(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * 根据code查询对象枚举
     * @param code
     * @return
     */
    public static ProfitTypeEnum getByCode(String code){
        if(null == code){
            return null;
        }

        for(ProfitTypeEnum profitType:ProfitTypeEnum.values()){
            if(code.equals(profitType.getCode())){
                return profitType;
            }
        }
        return null;
    }
}
