package com.bxm.shop.common.exception;


import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * @author yirenjie
 * createDate:  2018/7/12
 */
public class EnhanceResultModel<T> extends ResultModel<T> {

    public EnhanceResultModel() {
        setSuccessed(true);
    }

//    public EnhanceResultModel(T returnValue) {
//        if (returnValue instanceof ResponseCodeType){
//            ResponseCodeType codeType = (ResponseCodeType) returnValue;
//            setSuccessed(false);
//            setErrorCode(codeType.getErrorCode());
//            setErrorDesc(codeType.getErrorMsg());
//            return;
//        }
//        setSuccessed(true);
//        setReturnValue(returnValue);
//    }

    public EnhanceResultModel(ResponseCodeType codeType, String... msg) {
        setSuccessed(false);
        setErrorCode(codeType.getErrorCode());
        setErrorDesc(msg == null ? codeType.getErrorMsg() : String.format(codeType.getErrorMsg(), msg));
    }

    public EnhanceResultModel(Exception e) {
        setSuccessed(false);
        setErrorCode(ResponseCodeType.SYSTEM_ERROR.getErrorCode());
        setErrorDesc(e.getMessage());
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
