package com.bxm.shop.common.utils;


import java.math.BigDecimal;

/**
 * @author yirenjie
 * createDate:  2018/8/23
 */
public class CalculateUtils {

    public static Number divide(Number a, Number b) {
        return divide(a, b, 4);
    }

    public static Number divide(Number a, Number b, int scale) {
        if (a == null || b == null || b.intValue() == 0) {
            return null;
        }
        return new BigDecimal(a.doubleValue())
                .divide(BigDecimal.valueOf(b.doubleValue()), BigDecimal.ROUND_DOWN)
                .setScale(scale, BigDecimal.ROUND_DOWN).doubleValue();
    }

    public static Number multiply(Number a, Number b){
        return new BigDecimal(a.doubleValue()).multiply(BigDecimal.valueOf(b.doubleValue()));
    }

}
