package com.bxm.shop.common.utils;

import com.sun.jndi.toolkit.url.UrlUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

/**
 * 拼多多自定义参数处理类
 * @author bcc
 */
@Slf4j
public final class CustomParameterUtils {

    private CustomParameterUtils(){}


    public static final String SPLIT = "\\|";

    /**
     * 生成扩展参数
     * @param orderId
     * @param shareId
     * @param openid
     * @return
     */
    public static String generateCustomParameter(Long orderId,Long shareId,String openid){
        if(null == orderId){
            orderId = 0L;
        }
        if(null == shareId){
            shareId = 0L;
        }
        return StringUtils.join(new String[]{orderId+"",shareId+"",openid},"|");
    }

    /**
     * 订单ID
     * @param customParameter
     * @return
     */
    public static Long getOrderId(String customParameter){
        try {
            customParameter = UrlUtil.decode(customParameter, "UTF-8");
        } catch (Exception e) {
            log.error("decode自定义参数失败", e);
        }
        String[] split = customParameter.split(SPLIT);
        if(null != split && split.length>0){
            return Long.valueOf(split[0]);
        }
        return 0L;
    }

    /**
     * 分享ID
     * @param customParameter
     * @return
     */
    public static Long getShareId(String customParameter){
        String[] split = customParameter.split(SPLIT);
        if(null != split && split.length>1){
            return Long.valueOf(split[1]);
        }
        return 0L;
    }

    /**
     * openid
     * @param customParameter
     * @return
     */
    public static String getOpenid(String customParameter){
        String[] split = customParameter.split(SPLIT);
        if(null != split && split.length>2){
           return split[2];
        }
        return null;
    }

}
