/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.shop.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.warcar.utils.response.ResultModel;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 *
 * @author yirenjie
 */

public class NetUtils {
    public static final String COOKIE_LOGIN_KEY = "token";

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(COOKIE_LOGIN_KEY);
        if (token == null){
            token = request.getParameter(COOKIE_LOGIN_KEY);
        }
        return token;
    }

    public static void sendErrorMsg(HttpServletResponse response, ResponseCodeType responseCodeType) throws IOException {
        NetUtils.sendErrorMsg(response, responseCodeType.getErrorMsg(), responseCodeType.getErrorCode());
    }

    public static void sendErrorMsg(HttpServletResponse response, String errorMsg, String errorCode) throws IOException {
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorDesc(errorMsg);
        result.setErrorCode(errorCode);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String json = JSONObject.toJSONString(result);
        out.print(json);
        out.flush();
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
            //多次反向代理后会有多个ip值，第一个ip才是真实ip
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            } else {
                return ip;
            }
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }

        //解决用localhost访问ip为0:0:0:0:0:0:0:1的问题
        ip = request.getHeader("Proxy-Client-IP");
        if (ip != null) {
            if (!ip.isEmpty() && !"unKnown".equalsIgnoreCase(ip)) {
                return ip;
            }
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (ip != null) {
            if (!ip.isEmpty() && !"unKnown".equalsIgnoreCase(ip)) {
                return ip;
            }
        }
        ip = request.getRemoteAddr();
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
        //return request.getRemoteAddr();
    }

}
