package com.bxm.shop.facade;

import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.facade.model.Tag;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/11/8
 */
@FeignClient(name = "shops")
public interface GoodsService {

    @RequestMapping(value = "/home/getTags", method = RequestMethod.GET)
    ResultModel<List<Tag>> getTags(@RequestBody Integer parentId);

//    @RequestMapping(value = "/home/getBanners", method = RequestMethod.GET)
//    ResultModel<List<Banner>> getBanners();

    @RequestMapping(value = "/home/getGoodsList", method = RequestMethod.GET)
    ResultModel<List<GoodVo>> getGoodsList(@RequestBody GoodsQueryRo goodsQueryRo);

    @RequestMapping(value = "/queryGoodListByIds", method = RequestMethod.GET)
    ResultModel<List<GoodVo>> queryGoodListByIds(@RequestBody List<String> ids);

}
