package com.bxm.shop.facade;

import com.bxm.shop.facade.model.FeedbackQueryRo;
import com.bxm.shop.facade.model.FeedbackVo;
import com.bxm.shop.facade.model.Page;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author yirenjie
 * createDate:  2018/11/13
 */
@FeignClient(name = "shops-service")
public interface FeedbackService {

    @RequestMapping(value = "/feedback/submit", method = RequestMethod.PUT)
    ResultModel submit(@RequestBody FeedbackVo feedbackVo);

    @RequestMapping(value = "/feedback/list", method = RequestMethod.POST)
    ResultModel<Page<FeedbackVo>> listFeedback(@RequestBody FeedbackQueryRo queryRo);

}
