package com.bxm.shop.facade;

import com.bxm.shop.facade.model.*;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/11/8
 */
@FeignClient(name = "shops-service")
public interface GoodsService {

    @RequestMapping(value = "/goods/getTags", method = RequestMethod.POST)
    ResultModel<List<TagVo>> getTags();

//    @RequestMapping(value = "/home/getBanners", method = RequestMethod.GET)
//    ResultModel<List<Banner>> getBanners();

    @RequestMapping(value = "/goods/getGoodsList", method = RequestMethod.POST)
    ResultModel<Page<GoodVo>> getGoodsList(@RequestBody GoodsQueryRo goodsQueryRo);

    @RequestMapping(value = "/goods/queryGoodListByIds", method = RequestMethod.POST)
    ResultModel<List<GoodVo>> queryGoodListByIds(@RequestBody List<String> ids);

    @RequestMapping(value = "/goods/detail", method = RequestMethod.POST)
    ResultModel<GoodDetailVo> getDetail(@RequestBody String goodId);

    @RequestMapping(value = "/goods/search", method = RequestMethod.POST)
    ResultModel<Page<GoodVo>> search(@RequestBody GoodsQueryRo goodsQueryRo);

}
