package com.bxm.shop.facade.model.order;

import com.bxm.shop.facade.model.common.CommonDto;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 订单相关Dto
 * @author bcc
 */
@Getter
@Setter
@ToString
public class OrderDto extends CommonDto {

    private Long id;
    /**
     * 订单类型
     */
    private String type;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 分享ID
     */
    private Long shareId;

    /**
     * 分享者openid
     */
    private String shareOpenid;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单状态列表
     */
    private List<Integer> orderStatuses;

    /**
     * 数据删除日期
     */
    private Date date;

    /**
     * 同步订单开始时间
     */
    private Long startUpdateTime;

    /**
     * 同步订单结束时间
     */
    private Long endUpdateTime;



}
