package com.bxm.shop.facade.model.order;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单信息Dao
 */
@Getter
@Setter
@ToString
public class OrderSearchVo implements Serializable {

    private Long orderId;

    /**
     * 拼多多订单编号
     */
    private String orderSn;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 商品名
     */
    private String goodsName;

    /**
     * 商品缩略图
     */
    private String goodsThumbnailUrl;

    /**
     * 订单创建时间
     */
    private Long orderCreateTime;

    /**
     * 商品数量
     */
    private Integer goodsQuantity;

    /**
     * 商品价格（分）
     */
    private Long goodsPrice;

    /**
     * 订单价格（分）
     */
    private Long orderAmount;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单类型：
     * 无效：invalid
     * 待返现:cashbacking
     * 已返现:cashbacked
     */
    private String orderType;

    /**
     * 返现金额（分）
     */
    private Long rebateAmount;
}
