package com.bxm.shop;

import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/10/31 14:30
 */
@SpringBootApplication
@EnableDiscoveryClient
@MapperScan(basePackages = "com.bxm.shop.dal.mapper")
@EnableFeignClients({"com.bxm.shop.facade", "com.bxm.shopmanager.facade"})
public class ShopsServiceApplication {

	public static void main(String[] args) {
		SpringApplication application = new SpringApplication(com.bxm.shop.ShopsServiceApplication.class);
		application.addListeners(new SpringBootEnvironmentListener());
		application.run(args);
	}
}
