package com.bxm.shop.config;

import com.bxm.shop.utils.DistributedLock;
import com.bxm.warcar.cache.Updater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
public class DistributedLockConfig {
    @Autowired
    @Qualifier("jedisUpdater")
    protected Updater updater;

    @Bean
    public DistributedLock distributedLock(){
        JedisPool jedisPool = (JedisPool)updater.getClientOriginal();
        DistributedLock lock = new DistributedLock(jedisPool);
        return lock;
    }

}
