package com.bxm.shop.config;

import com.bxm.shop.dal.UserDao;
import org.dozer.DozerBeanMapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static org.dozer.loader.api.TypeMappingOptions.mapEmptyString;
import static org.dozer.loader.api.TypeMappingOptions.mapNull;

/**
 * dozer配置，用于属性拷贝
 * @author bcc
 */
@Configuration
public class
DozerBeanMapperConfig {

    @Bean
    public DozerBeanMapper mapper() {
        DozerBeanMapper mapper = new DozerBeanMapper();
        mapper.addMapping(new BeanMappingBuilder() {
            @Override
            protected void configure() {
                mapping(UserDao.class, UserDao.class, mapNull(false), mapEmptyString(false));
            }
        });
        return mapper;
    }

}