package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.facade.model.feedback.FeedbackQueryRo;
import com.bxm.shop.facade.model.feedback.FeedbackVo;
import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.service.FeedbackService;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2018/11/13
 */
@RequestMapping("/feedback")
@RestController
@Slf4j
public class FeedbackController {

    @Resource
    private FeedbackService feedbackService;

    @RequestMapping("/submit")
    public ResultModel submit(@RequestBody FeedbackVo feedbackVo){
        ResultModel result = new ResultModel();
        result.setSuccessed(feedbackService.addFeedback(feedbackVo));
        return result;
    }

    @RequestMapping(value = "/list", produces = "application/json")
    public ResultModel<Page<FeedbackVo>> listFeedback(@RequestBody FeedbackQueryRo queryRo) {
        log.info("获取反馈列表请求参数:{}", queryRo);
        ResultModel<Page<FeedbackVo>> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(feedbackService.listFeedback(queryRo));
        return resultModel;
    }

}
