package com.bxm.shop.controllers;

import com.bxm.shop.dal.mapper.UserMapper;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.service.FriendService;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/friend")
@Slf4j
public class FriendController {

    @Autowired
    private FriendService friendService;

    /**
     * 获取好友概况
     * @param dto
     * @return
     */
    @RequestMapping("/info")
    public ResultModel info(@RequestBody CommonDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(friendService.getInfo(dto.getOpenid()));
        return rs;
    }

    @RequestMapping("/findDirectFriends")
    public ResultModel findDirectFriends(@RequestBody CommonDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(friendService.findDirectFriends(dto));
        return rs;
    }


    @RequestMapping("/findIndirectFriends")
    public ResultModel findIndirectFriends(@RequestBody CommonDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(friendService.findIndirectFriends(dto));
        return rs;
    }

}
