package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.facade.model.goods.*;
import com.bxm.shop.facade.model.tag.TagVo;
import com.bxm.shop.integration.pdd.PddGoodsIntegration;
import com.bxm.shop.model.goods.vo.Good;
import com.bxm.shop.service.BoostService;
import com.bxm.shop.service.GoodsService;
import com.bxm.shop.service.TagService;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.dozer.Mapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 首页
 * @author yirenjie
 * createDate:  2018/11/8
 */
@RestController
@RequestMapping("/goods")
@Slf4j
public class GoodsController {

    @Resource
    private GoodsService goodsService;

    @Resource
    private TagService tagService;

    @Resource
    private PddGoodsIntegration pddGoodsIntegration;

    @Resource
    private BoostService boostService;

    @Resource
    private Mapper mapper;

    @RequestMapping("/getTags")
    public ResultModel<List<TagVo>> getTags(){
        ResultModel<List<TagVo>> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(tagService.getTagsByParentId());
        return resultModel;
    }

    @RequestMapping("/getGoodsList")
    public ResultModel<Page<GoodsVo>> getGoodsList(@RequestBody GoodsQueryRo goodsQueryRo){
        ResultModel<Page<GoodsVo>> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(goodsService.getList(goodsQueryRo));
        return resultModel;
    }

    @RequestMapping("/search")
    public ResultModel<Page<GoodsVo>> search(@RequestBody GoodsQueryRo goodsQueryRo){
        ResultModel<Page<GoodsVo>> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(goodsService.search(goodsQueryRo));
        return resultModel;
    }

    @RequestMapping("/queryGoodListByIds")
    public ResultModel<List<GoodsManageVo>> queryGoodListByIds(@RequestBody List<String> ids) {
        log.debug("ids:{}", ids);
        List<Good> goods = pddGoodsIntegration.queryGoodsList(ids);
        if (goods != null) {
            EnhanceResultModel<List<GoodsManageVo>> resultModel = new EnhanceResultModel<>();
            resultModel.setReturnValue(goods.stream()
                    .map(good -> {
                        GoodsManageVo goodsManageVo = mapper.map(good, GoodsManageVo.class);
                        long price = good.getMinGroupPrice() - good.getCouponDiscount();
                        goodsManageVo.setPrice(price);
                        return goodsManageVo;
                    }).collect(Collectors.toList()));
            return resultModel;
        }
        return new EnhanceResultModel<>(ResponseCodeType.SYSTEM_ERROR);
    }

    @RequestMapping("/detail")
    public ResultModel<GoodsDetailVo> getDetail(@RequestBody String goodsId){
        EnhanceResultModel<GoodsDetailVo> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(goodsService.getDetail(goodsId));
        return resultModel;
    }

    @RequestMapping("/getThemeGoodsList")
    public ResultModel<ThemeGoodsVo> getThemeGoodsList(Long goodsPoolId){
        EnhanceResultModel<ThemeGoodsVo> resultModel = new EnhanceResultModel<>();
        resultModel.setReturnValue(goodsService.getThemeGoodsList(goodsPoolId));
        return resultModel;
    }

    @RequestMapping("/searchGoodsPoolDetail")
    public ResultModel<GoodsPoolVO> getGoodsPoolById(@RequestBody Long id){
        ResultModel<GoodsPoolVO> rs = new ResultModel<>();
        rs.setReturnValue(goodsService.getGoodsPoolById(id));
        return rs;
    }

    @RequestMapping("/boostStatus")
    public ResultModel<String> boostStatus(String openid){
        ResultModel<String> rs = new ResultModel<>();
        rs.setReturnValue(boostService.boostStatus(openid).name());
        return rs;
    }

    @RequestMapping("/getPops")
    public ResultModel<List<GoodsDetailVo.Pop>> getPops(){
        ResultModel<List<GoodsDetailVo.Pop>> rs = new ResultModel<>();
        rs.setReturnValue(goodsService.getPops());
        return rs;
    }
}
