package com.bxm.shop.controllers;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.dal.mapper.OrderDetailMapper;
import com.bxm.shop.dal.mapper.WechatWithdrawRecordMapper;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.model.order.dao.OrderDetailDao;
import com.bxm.shop.model.wechat.WechatWithdrawRecordDao;
import com.bxm.shop.service.OrderService;
import com.bxm.warcar.utils.response.ResultModel;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/order")
public class OrderController {

    @Autowired
    private OrderService orderService;

    @Autowired
    private WechatWithdrawRecordMapper wechatWithdrawRecordMapper;

    /**
     * 生成虚拟订单
     * @param dto
     * @return
     */
    @RequestMapping("/add")
    public ResultModel add(@RequestBody OrderDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(orderService.add(dto));
        return rs;
    }

    /**
     * 删除长时间未关联拼多多订单的虚拟订单
     * 定时任务调用
     * @param dto
     * @return
     */
    @RequestMapping("/deleteAbandonOrder")
    public ResultModel deleteAbandonOrder(@RequestBody OrderDto dto){
        ResultModel rs = new ResultModel();
        if(null == dto.getDate()){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ResponseCodeType.PARAM_ILLEGAL.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.PARAM_ILLEGAL.getErrorMsg());
            return rs;
        }else{
            //至少保留最近一天的数据
            if(dto.getDate().after(DateUtils.addDays(new Date(),-1))){
                rs.setSuccessed(Boolean.FALSE);
                rs.setErrorCode(ResponseCodeType.PARAM_ILLEGAL.getErrorCode());
                rs.setErrorDesc(ResponseCodeType.PARAM_ILLEGAL.getErrorMsg());
                return rs;
            }
        }
        orderService.deleteAbandonOrder(dto.getDate());
        return rs;
    }

    /**
     * 同步拼多多订单信息
     * @param dto
     * @return
     */
    @RequestMapping(value = "/synchronizeOrder", method = { RequestMethod.POST})
    public ResultModel synchronizeOrder(@RequestBody OrderDto dto){
        ResultModel rs = new ResultModel();
        //拼多多的订单增量查询接口最多只能查询1天的订单
        if(null == dto.getStartUpdateTime() || dto.getStartUpdateTime()+24*3600< dto.getEndUpdateTime()){
            rs.setSuccessed(Boolean.FALSE);
            rs.setErrorCode(ResponseCodeType.PARAM_ILLEGAL.getErrorCode());
            rs.setErrorDesc(ResponseCodeType.PARAM_ILLEGAL.getErrorMsg());
            return rs;
        }
        orderService.synchronizeOrder(dto);
        return rs;
    }

    /**
     * 统计商品卖出数量
     * @param goodsId
     * @return
     */
    @RequestMapping(value = "/statisticsSoldGoodsNum", method = { RequestMethod.POST})
    public ResultModel statisticsSoldGoodsNum(@RequestBody List<String> goodsId){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(orderService.statisticsSoldGoodsNum(goodsId));
        return rs;
    }


    /**
     * 按状态查询订单
     * @param dto
     * @return
     */
    @RequestMapping(value = "/find", method = { RequestMethod.POST})
    public ResultModel find(@RequestBody OrderDto dto){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(orderService.find(dto));
        return rs;
    }



}
