package com.bxm.shop.controllers;

import com.bxm.shop.service.WechatService;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.xml.ws.soap.Addressing;

@RestController
@RequestMapping("/wechat")
public class WechatController {

    @Autowired
    private WechatService wechatService;

    /**
     * 获取accessToken
     * @return
     */
    @RequestMapping("getAccessToken")
    public ResultModel getAccessToken(){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(wechatService.getAccessToken());
        return rs;
    }

    /**
     * accessToken失效后刷新
     * @return
     */
    @RequestMapping("refreshAccessToken")
    public ResultModel refreshAccessToken(){
        ResultModel rs = new ResultModel();
        rs.setReturnValue(wechatService.refreshAccessToken());
        return rs;
    }
}
