package com.bxm.shop.handler;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.exception.ShopsException;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Slf4j
@ControllerAdvice
public class GlobalControllerExceptionHandler {

    @ExceptionHandler
    @ResponseBody
    public ResultModel runtimeExceptionHandler(Exception e) {
        log.error("系统错误:", e);
        return new EnhanceResultModel(ResponseCodeType.SYSTEM_ERROR);
    }

    @ExceptionHandler(ShopsException.class)
    @ResponseBody
    public ResultModel<Boolean> validateExceptionHandler(ShopsException e) {
        // 打印错误日志
        log.error("系统异常:", e);
        return new EnhanceResultModel<>(e);
    }

    @ExceptionHandler(MissingServletRequestParameterException.class)
    @ResponseBody
    public ResultModel<Boolean> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException e) {
        // 打印错误日志
        log.warn("参数缺失:", e);
        return new EnhanceResultModel<>(ResponseCodeType.PARAM_ILLEGAL, e.getMessage());
    }

    @ExceptionHandler(ServletRequestBindingException.class)
    @ResponseBody
    public ResultModel<Boolean> servletRequestBindingExceptionHandler(ServletRequestBindingException e) {
        // 打印错误日志
        log.warn("---------> system huge error:", e);
        return new EnhanceResultModel<>(e);
    }

}

