package com.bxm.shop.interceptors.profit;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.utils.CustomParameterUtils;
import com.bxm.shop.dal.mapper.UserProfitMapper;
import com.bxm.shop.facade.model.order.PddOrderInfo;
import com.bxm.shop.model.profit.dao.UserProfitDao;
import com.bxm.shop.dal.UserDao;
import com.bxm.shop.service.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.Resource;
import java.util.Date;

public abstract class AbstractProfitInterceptor extends AbstractInterceptor {

    @Autowired
    private UserProfitMapper userProfitMapper;

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    private Mapper mapper;

    @Resource
    private UserService userService;

    @Override
    protected void doIntercept(Invocation invocation) {
        ProfitRequestModel requestModel = (ProfitRequestModel) invocation.getRequestModel();
        if(needSaveOrUpdate(requestModel)) {
            //获取佣金(分)
            PddOrderInfo pddOrderInfo = requestModel.getPddOrderInfo();
            if (null != requestModel.getRebateConfig()) {
                //返利金额
                long profitAmount = getProfitAmount(requestModel);
                Long orderId = CustomParameterUtils.getOrderId(pddOrderInfo.getCustomParameters());
                String openid = CustomParameterUtils.getOpenid(pddOrderInfo.getCustomParameters());
                if(StringUtils.isBlank(openid)){
                    openid = requestModel.getOrderDao().getOpenid();
                }
                int count = userProfitMapper.updateStatusByOrderIdAndType(orderId, pddOrderInfo.getOrderStatus(), getProfittype());
                //收益有影响的人
                requestModel.getProfitRelatedUser().add(getProfitOwner(requestModel));
                //更新数量为0，需新增
                if (count == 0) {
                    UserProfitDao dao = new UserProfitDao();
                    mapper.map(pddOrderInfo, dao);
                    dao.setOpenid(getProfitOwner(requestModel));
                    dao.setOrderOwnerOpenid(openid);
                    UserDao info = getUserDao(requestModel, openid);
                    dao.setOrderParentOpenid(info.getParentOpenid());
                    dao.setProfitType(getProfittype());
                    dao.setCreateTime(new Date());
                    dao.setOrderId(orderId);
                    dao.setProfitAmount(profitAmount);

                    userProfitMapper.save(dao);
                }

            }
        }

    }

    protected UserDao getUserDao(ProfitRequestModel requestModel, String openid) {
        UserDao info = requestModel.getUserDao();
        if (null == info) {
            info = userService.getUserByOpenid(openid);
            requestModel.setUserDao(info);
        }
        return info;
    }

    /**
     * 收益类型
     * @return
     */
    public abstract String getProfittype();

    /**
     * 收益金额
     * @return
     */
    public abstract Long getProfitAmount(ProfitRequestModel requestModel);

    /**
     * 收益所有人
     * @return
     */
    public abstract  String getProfitOwner(ProfitRequestModel requestModel);

    /**
     * 是否需要保存或者更新收益
     * （例如没有分享者不用计算分享者收益）
     * @return
     */
    public abstract  Boolean needSaveOrUpdate(ProfitRequestModel requestModel);

}
