package com.bxm.shop.interceptors.profit;

import com.bxm.shop.common.enums.ProfitTypeEnum;
import com.bxm.shop.common.utils.CustomParameterUtils;
import com.bxm.shop.dal.UserDao;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 上上级返利处理
 * @author bcc
 */
@Component
public class GrandparentInterceptor extends AbstractProfitInterceptor {

    @Override
    public String getProfittype() {
        return ProfitTypeEnum.GRANDPARENT.getCode();
    }

    @Override
    public Long getProfitAmount(ProfitRequestModel requestModel) {
        long promotionAmount = 0L;
        if(null != requestModel.getPddOrderInfo().getPromotionAmount()){
            promotionAmount = requestModel.getPddOrderInfo().getPromotionAmount();
        }
        return promotionAmount * requestModel.getRebateConfig().getPre2() / 100;
    }

    @Override
    public String getProfitOwner(ProfitRequestModel requestModel) {
        String openid = CustomParameterUtils.getOpenid(requestModel.getPddOrderInfo().getCustomParameters());
        UserDao userDao = getUserDao(requestModel, openid);
        return userDao.getGrandparentOpenid();
    }

    @Override
    public Boolean needSaveOrUpdate(ProfitRequestModel requestModel) {
        String openid = CustomParameterUtils.getOpenid(requestModel.getPddOrderInfo().getCustomParameters());
        if(StringUtils.isBlank(openid)){
            openid = requestModel.getOrderDao().getOpenid();
        }
        UserDao userDao = getUserDao(requestModel, openid);
        //存在上上级用户，且上上级返利金额大于0
        if(null != userDao && StringUtils.isNotBlank(userDao.getGrandparentOpenid())&&
                requestModel.getRebateConfig().getPre2()>0 && null != requestModel.getPddOrderInfo().getPromotionAmount()&&
                requestModel.getPddOrderInfo().getPromotionAmount()>0){
            return true;
        }
        return false;
    }

}
