package com.bxm.shop.interceptors.profit;

import com.bxm.shop.service.WalletSerive;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 缓存收益变动人的可提现金额，待返现金额等信息
 * @author bcc
 */
@Component
@Slf4j
public class ProfitCacheInterceptor extends AbstractInterceptor {

    @Autowired
    private WalletSerive walletSerive;

    @Override
    protected void doIntercept(Invocation invocation) {
        ProfitRequestModel requestModel = (ProfitRequestModel) invocation.getRequestModel();
        for(String openid:requestModel.getProfitRelatedUser()){
            walletSerive.cacheProfit(openid);
        }
    }
}
