package com.bxm.shop.interceptors.profit;

import com.bxm.shop.utils.InterceptorChainUtils;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.google.common.collect.Lists;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 收益处理链
 * @author bcc
 */
@Component
public class ProfitInterceptorChain implements Interceptor , InitializingBean {

    private final List<Interceptor> interceptors = Lists.newArrayList();

    /**
     * 自购返利
     */
    @Autowired
    private PurchaseInterceptor purchaseInterceptor;

    /**
     * 分享返利
     */
    @Autowired
    private ShareInterceptor shareInterceptor;

    /**
     * 上级返利
     */
    @Autowired
    private ParentInterceptor parentInterceptor;

    /**
     * 上上级返利
     */
    @Autowired
    private GrandparentInterceptor grandparentInterceptor;

    /**
     * 收益缓存
     */
    @Autowired
    private ProfitCacheInterceptor profitCacheInterceptor;

    /**
     * 0元购处理
     */
    @Autowired
    private FreeOrderInterceptor freeOrderInterceptor;

    private void addInterceptors() {
        interceptors.add(freeOrderInterceptor);
        interceptors.add(purchaseInterceptor);
        interceptors.add(shareInterceptor);
        interceptors.add(parentInterceptor);
        interceptors.add(grandparentInterceptor);
        interceptors.add(profitCacheInterceptor);
        InterceptorChainUtils.setChain(interceptors);
    }

    @Override
    public void intercept(Invocation invocation) {
        interceptors.get(0).intercept(invocation);
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        if(interceptors.size() ==0) {
            addInterceptors();
        }
    }
}
