package com.bxm.shop.interceptors.profit;

import com.bxm.shop.common.enums.ProfitTypeEnum;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.facade.model.order.PddOrderInfo;
import com.bxm.shop.model.RebateConfig;
import com.bxm.shop.model.OrderType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 自购返利处理
 * @author bcc
 */
@Component
@Slf4j
public class PurchaseInterceptor extends AbstractProfitInterceptor {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String getProfittype() {
        return ProfitTypeEnum.PURCHASE.getCode();
    }

    @Override
    public Long getProfitAmount(ProfitRequestModel requestModel) {
        long result = 0L;
        long promotionAmount = 0L;
        PddOrderInfo pddOrderInfo = requestModel.getPddOrderInfo();
        long maxAmount = Long.valueOf(stringRedisTemplate.opsForValue().get(RedisConstants.FREE_MAX_AMOUNT));
        if (null != pddOrderInfo.getPromotionAmount()) {
            promotionAmount = pddOrderInfo.getPromotionAmount();
        }
        RebateConfig rebateConfig = requestModel.getRebateConfig();

        if (rebateConfig.getFinalPrice() == null) {
            result = promotionAmount * rebateConfig.getSelfPurchase() / 100;
        } else {
            result = (long) (pddOrderInfo.getOrderAmount() * 1.0 / pddOrderInfo.getGoodsQuantity());
        }

        if (requestModel.getOrderDao().getOrderType() == OrderType.FREE) {
            result = result > maxAmount ? maxAmount : result;
        }
        return result;
    }

    @Override
    public String getProfitOwner(ProfitRequestModel requestModel) {
        return requestModel.getOrderDao().getOpenid();
    }

    @Override
    public Boolean needSaveOrUpdate(ProfitRequestModel requestModel) {
        if (requestModel.getPddOrderInfo().getPromotionAmount() == null || requestModel.getPddOrderInfo().getPromotionAmount() <= 0) {
            return false;
        }
        RebateConfig rebateConfig = requestModel.getRebateConfig();
        if ((rebateConfig.getSelfPurchase() == null || rebateConfig.getSelfPurchase() < 0)&& rebateConfig.getFinalPrice() == null) {
            return false;
        }
        return true;
    }

}