package com.bxm.shop.service;

import com.bxm.shop.facade.model.boost.BoostDetailVo;
import com.bxm.shop.facade.model.boost.CreateBoostRo;
import com.bxm.shop.facade.model.goods.FreeGoodsVo;

/**
 * @author yirenjie
 * createDate:  2018/12/21
 */
public interface BoostService {

    /**
     * 获取0元购商品
     * @param openid
     * @return
     */
    FreeGoodsVo list(String openid);

    /**
     * 根据openid获取详情
     * @param openid 微信openid
     * @param boostId
     */
    BoostDetailVo getDetail(String openid, Long boostId);

    /**
     * 助力
     */
    void boost(String openid, Long boostId);

    /**
     * 根据boostId获取详情
     * @param boostId
     */
    Long createBoost(CreateBoostRo boostId);

    /**
     * 获取用户助力状态
     * @param openid
     * @return
     */
    FreeGoodsVo.PageType boostStatus(String openid);
}
