package com.bxm.shop.service;


import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.facade.model.goods.GoodsDetailVo;
import com.bxm.shop.facade.model.goods.GoodsPoolVO;
import com.bxm.shop.facade.model.goods.GoodsQueryRo;
import com.bxm.shop.facade.model.goods.GoodsVo;
import com.bxm.shop.facade.model.goods.ThemeGoodsVo;
import com.bxm.shop.model.RebateConfig;
import com.bxm.shop.model.goods.vo.Good;

import java.util.List;
import java.util.Map;

/**
 * @author yirenjie
 * createDate:  2018/11/8
 */
public interface GoodsService {

    /**
     * 查询商品列表
     * @param goodsQueryRo
     */
    Page<GoodsVo> getList(GoodsQueryRo goodsQueryRo);

    GoodsDetailVo getDetail(String goodId);

    Page<GoodsVo> search(GoodsQueryRo goodsQueryRo);

    GoodsVo trans2Vo(Good good, List<String> freeGoodsIds, Map<String,RebateConfig> rebateConfigs);

    /**
     * 获取主题商品列表
     * @param themeId
     */
    ThemeGoodsVo getThemeGoodsList(Long goodsPoolId);

    GoodsPoolVO getGoodsPoolById(Long id);

    List<GoodsDetailVo.Pop> getPops();
}
