package com.bxm.shop.service.impl;

import com.bxm.shop.common.utils.ExceptionPrintUtils;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.config.CounterConfig;
import com.bxm.shop.dal.mapper.CounterMapper;
import com.bxm.shop.facade.model.counter.CounterDto;
import com.bxm.shop.model.counter.CounterDao;
import com.bxm.shop.service.CounterService;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.commons.lang.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Service
public class CounterServiceImpl implements CounterService {

    @Autowired
    private CounterMapper counterMapper;

    @Autowired
    private Mapper mapper;

    @Autowired
    private CounterConfig counterConfig;

    @Autowired
    private MessageSender messageSender;

    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors()*2,
            Runtime.getRuntime().availableProcessors()*2,0L, TimeUnit.SECONDS,new LinkedBlockingDeque(),
            new ThreadFactoryBuilder().setNameFormat("CounterServiceImpl-pool-%d").build()
    );

    @Override
    public int save(CounterDto dto) {
        CounterDao dao = new CounterDao();
        mapper.map(dto,dao);
        dao.setCreateTime(new Date());
        if(StringUtils.isNotEmpty(dto.getArticleId())){
            dao.setBxmId("ArticleId:"+dto.getArticleId());
        }else{
            if(StringUtils.isEmpty(dao.getBxmId())){
                dao.setBxmId("null");
            }
            //调用效果监控
            if("entrance".equals(dao.getType())){
                poolExecutor.execute(() -> {
                    sendCounter(dto.getBxmId());
                });
            }
        }
        return counterMapper.save(dao);
    }


    private void sendCounter(String bxmId){
        Map<String,String> params = new HashMap<>();
        params.put("bxm_id",bxmId);
        params.put("status","1");
        params.put("modeltype","7");
        String response = null;
        try {
            response = OkHttpUtils.post(counterConfig.getCounterUrl(),params);
        } catch (IOException e) {
            Message msg = new Message();
            msg.setContent("shops-service调用效果监控出错 "+ ExceptionPrintUtils.printStackTraceToString(e));
            messageSender.send2(msg);
        }
    }
}
