package com.bxm.shop.service.impl;

import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.dal.Boost;
import com.bxm.shop.dal.UserDao;
import com.bxm.shop.dal.mapper.BoostMapper;
import com.bxm.shop.dal.mapper.UserShareMapper;
import com.bxm.shop.facade.UserShareService;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.model.user.dao.UserShareDao;
import com.bxm.shop.service.UserService;
import com.bxm.shop.utils.DistributedLock;
import com.bxm.warcar.utils.response.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.dozer.Mapper;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Date;
import java.util.UUID;

/**
 * @author yirenjie
 * createDate:  2019/1/23
 */
@RestController
@Slf4j
public class UserShareServiceImpl implements UserShareService {

    @Resource
    private Mapper mapper;

    @Resource
    private UserShareMapper userShareMapper;

    @Resource
    private BoostMapper boostMapper;

    @Resource
    private DistributedLock distributedLock;

    @Resource
    private UserService userService;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public ResultModel<Long> add(@RequestBody CommonDto dto) {
        ResultModel<Long> resultModel = new EnhanceResultModel<>();

        Long id = findShareIdByOpenidAndGoodsId(dto.getOpenid(), dto.getGoodsId());
        if(id != null && id >0){
            resultModel.setReturnValue(id);
            return resultModel;
        }
        UserShareDao dao = new UserShareDao();
        mapper.map(dto,dao);
        dao.setCreateTime(new Date());
        userShareMapper.save(dao);
        resultModel.setReturnValue(dao.getId());
        return resultModel;
    }

    private Long findShareIdByOpenidAndGoodsId(String openid, String goodsId) {
        return userShareMapper.findByOpenidAndGoodsId(openid,goodsId);
    }

    @Override
    public ResultModel callback(String openid) {
        ResultModel<Long> resultModel = new EnhanceResultModel<>();
        String lockKey = "SHARE_CALLBACK" + openid;
        String requestId = UUID.randomUUID().toString();
        try {
            distributedLock.lock(lockKey, requestId, 60 * 1000);

            // 前置判断
            UserDao info = userService.getUserByOpenid(openid);
            Integer usedFreeTimes = info.getFreeTimes();
            Integer availableFreeTimes = info.getAvailableFreeTimes();
            Integer initAvailableFreeTimes = Integer.valueOf(stringRedisTemplate.opsForValue().get(RedisConstants.INIT_FREE_TIMES));   // 赠送用户次数
            Integer shareFreeTimes = Integer.valueOf(stringRedisTemplate.opsForValue().get(RedisConstants.SHARE_FREE_TIMES));   // 可用分享次数
            int freeTimes = Integer.valueOf(stringRedisTemplate.opsForValue().get(RedisConstants.FREE_TIMES));
            if (usedFreeTimes >= freeTimes) {
                resultModel.setSuccessed(false);
                log.error("所有助力机会耗尽");
                return resultModel;
            }

            if (availableFreeTimes >= 1 || usedFreeTimes >= initAvailableFreeTimes + shareFreeTimes) {
                resultModel.setSuccessed(false);
                log.error("免费赠送机会未使用完或通过分享获取助力次数已用完");
                return resultModel;
            }

            Boost leastBoost = boostMapper.findLeastByOpenid(openid);
            if (leastBoost != null && !leastBoost.getStatus().isFinished()) {
                resultModel.setSuccessed(false);
                log.error("最近一条助力还未结束");
                return resultModel;
            }

            Boost boost = new Boost();
            boost.setOpenid(openid);
            boost.setRequiredAmount(0);
            boost.setStatus(Boost.Status.S);
            boost.setBoostType(Boost.BoostType.SHARE);
            boostMapper.insertSelective(boost);
            return resultModel;
        } finally {
            distributedLock.releaseDistributedLock(lockKey, requestId);
        }
    }
}
