package com.bxm.shop.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.constants.WeChatConstants;
import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.model.wechat.SendTemplateMessageRo;
import com.bxm.shop.service.WechatService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class WechatServiceImpl implements WechatService {

    @Autowired
    private WechatConfig wechatConfig;

    @Autowired
    private MessageSender messageSender;

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    public String getAccessToken() {
        String accessToken = fetcher.fetch(RedisConstants.Wechat.getAccessToken(), String.class);
        if(StringUtils.isEmpty(accessToken)){
           return  refreshAccessToken();
        }
        return accessToken;
    }

    @Override
    public String refreshAccessToken() {
        String accessToken = doGetAccessToken();
        updater.update(RedisConstants.Wechat.getAccessToken(),accessToken, RedisConstants.Wechat.VALID_TIME);
        return accessToken;
    }

    @Override
    @Async
    public void sendTemplateMessage(SendTemplateMessageRo ro) {
        String response = null;
        try {
            String url = wechatConfig.getSendTemplateMessage() + "?access_token=" + getAccessToken();
            response = OkHttpUtils.post(url, JSONObject.toJSONString(ro));
            JSONObject jsonObject = JSONObject.parseObject(response);
            if ("40014".equals(jsonObject.get("errcode"))) {
                String newUrl = wechatConfig.getSendTemplateMessage() + "?access_token=" + refreshAccessToken();
                response = OkHttpUtils.post(newUrl, JSONObject.toJSONString(ro));
            }
            if (0 != (JSONObject.parseObject(response).getInteger("errcode"))) {
                log.error("发送微信消息失败:response={}", response);
            }
        } catch (Exception e) {
            log.error("发送微信消息失败", e);
        }
    }

    /**
     * 获取accessToken
     * @return
     */
    private String doGetAccessToken(){
        Map<String,String> params = new HashMap<>();
        params.put(WeChatConstants.Param.APP_ID,wechatConfig.getAppId());
        params.put(WeChatConstants.Param.SECRET,wechatConfig.getAppSecret());
        params.put(WeChatConstants.Param.GRANT_TYPE,WeChatConstants.Param.CLIENT_CREDENTIAL);
        String response = null;
        Message msg = new Message();
        msg.setContent("获取微信accesstoken error");
        try {
            response = OkHttpUtils.get(wechatConfig.getAccessTokenUrl(),params);
        } catch (IOException e) {
            messageSender.send2(msg);
            log.error("doGetAccessToken error ",e);

        }
        if(null != response) {
            JSONObject obj = JSON.parseObject(response);
            if(null != obj && null != obj.getString(WeChatConstants.Param.ACCESS_TOKEN)){
                return obj.getString(WeChatConstants.Param.ACCESS_TOKEN);
            }
        }
        messageSender.send2(msg);
        return null;
    }


}
