package com.bxm.shop.utils;


import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;

import java.util.List;

/**
 * @author allen
 * @since V1.0.0 2017/12/29
 */
public class InterceptorChainUtils {

    public static void setChain(List<Interceptor> interceptors) {
        // 按添加顺序设置链条
        for (int i = 0; i < interceptors.size(); i++) {
            Interceptor interceptor = interceptors.get(i);
            if (interceptor instanceof AbstractInterceptor) {
                boolean isLast = i + 1 == interceptors.size();
                if (! isLast) {
                    ((AbstractInterceptor) interceptor).setNextInterceptor(interceptors.get(i + 1));
                }
            }
        }
    }
}
