package com.bxm.shop.utils;

import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClients;

import javax.net.ssl.SSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;

/**
 * https ssl 
 * @author
 *
 */
public class SSLCustomClient{
	/**
	 * 
	 * @param filePath
	 * @param password
	 * @return
	 * @throws Exception
	 */
	 public static HttpClient getSSLClient(String filePath,String password) throws Exception{  
	        KeyStore keyStore  = KeyStore.getInstance("PKCS12");
	        File targetFile = new File(filePath);
	        FileInputStream instream = new FileInputStream(targetFile);
	        try {
	            keyStore.load(instream, password.toCharArray());
	        } finally {
	            instream.close();
	        }

	        // Trust own CA and all self-signed certs
	        SSLContext sslcontext = SSLContexts.custom()
	                .loadKeyMaterial(keyStore, password.toCharArray())
	                .build();
	        // Allow TLSv1 protocol only
	        SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(
	                sslcontext,
	                new String[] { "TLSv1" },
	                null,
	                SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
	        return HttpClients.custom()
	                .setSSLSocketFactory(ssf)
	                .build();
	 }
	
}
