package com.bxm.shop.wxpay;

import com.bxm.shop.config.WechatConfig;
import com.bxm.shop.utils.*;
import com.bxm.shop.wxpay.dto.PayPerson;
import com.bxm.shop.wxpay.dto.PayPersonReturn;
import com.bxm.shop.wxpay.dto.TransferinfoDto;
import com.bxm.shop.wxpay.dto.TransferinfoReturn;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 微信支付工具类
 */
public  final class WxPayUtil {
    private static Logger logger = LoggerFactory.getLogger(WxPayUtil.class);
    private static ConcurrentHashMap fieldMap = new ConcurrentHashMap();
    /**
     * 支付的主方法
     * @param payPersonBean
     * @return
     * @throws Exception
     */
    public static PayPersonReturn payPersion(PayPerson payPersonBean, WechatConfig config) throws Exception {
//        if(1 == 1){
//            //测试用不真实提现，30%概率失败
//            double random = Math.random();
//            if(random>0.3) {
//                System.out.println("===========SUCCESS");
//                PayPersonReturn re = new PayPersonReturn();
//                re.setResultCode("SUCCESS");
//                re.setPaymentNo("testPaymentNo");
//                re.setPaymentTime("testPaymentTime");
//                return re;
//            }else{
//                System.out.println("===========FAIL");
//                PayPersonReturn re = new PayPersonReturn();
//                re.setResultCode("FAIL");
//                re.setErrCode("testErrorCode");
//                re.setErrCodeDes("testErrorDes");
//                return re;
//            }
//        }
        payPersonBean.setCheckName("NO_CHECK");
        payPersonBean.createSign(config);
        String data = XmlFactory.toXml(payPersonBean);
        if(logger.isDebugEnabled()) {
            logger.debug("payPersion request data :" + data);
        }
        String result = HttpClientUtil.post(config.getPayPersonUrl(), data,config.getCertPath(), config.getMchId());
        PayPersonReturn payPersonReturn =XmlFactory.toBean(result, PayPersonReturn.class);
        return payPersonReturn;
    }

    /**
     * 查询订单
     * @param payPersonBean
     * @param config
     * @return
     * @throws Exception
     */
    public static TransferinfoReturn payQuery(TransferinfoDto transferinfoDto, WechatConfig config) throws Exception {
        transferinfoDto.setNonceStr(createUniqueCode(20));
        transferinfoDto.createSign(config);
        String data = XmlFactory.toXml(transferinfoDto);
        if(logger.isDebugEnabled()) {
            logger.debug("payQuery request data :" + data);
        }
        String result = HttpClientUtil.post(config.getPayQueryUrl(), data,config.getCertPath(), config.getMchId());
        TransferinfoReturn transferinfoReturn =XmlFactory.toBean(result, TransferinfoReturn.class);
        return transferinfoReturn;
    }

    public static String createSign(Object object,String keySecret) throws IllegalArgumentException, IllegalAccessException, UnsupportedEncodingException {
        return createSign(object,keySecret,false);
    }
    public static String createSign(Object object,String keySecret,boolean parseKeyFlag) throws IllegalArgumentException, IllegalAccessException, UnsupportedEncodingException {
        TreeMap treeMap = new TreeMap();
        StringBuffer beforeSign = new StringBuffer();
        Class<?> cls = object.getClass();
        Class<?> superCls=cls.getSuperclass();
        getClassFields(treeMap, object, cls, parseKeyFlag);
        if(superCls != null){
            getClassFields(treeMap, object, superCls, parseKeyFlag);
        }
        Iterator<String> ir = treeMap.keySet().iterator();
        while(ir.hasNext()){
            Object key= ir.next();
            Object value = treeMap.get(key);
            //ios 对布尔型自动转化0，1
            if(value.equals(true)){
                value = 1;
            }else if(value.equals(false)){
                value = 0;
            }
            if(key.equals("devType")){
                value = ((String)value).replaceAll("GSM CDMA", "GSM+CDMA");
            }
            beforeSign.append(key).append("=").append(value).append("&");
        }
        beforeSign.append("key="+keySecret);
        if(logger.isDebugEnabled()){
            logger.debug("before sign:"+beforeSign);
        }
        String sign = EncryptUtils.encryptToMD5(beforeSign.toString()).toUpperCase();
        logger.info("before sign:"+beforeSign+"  sign:"+sign);
        return sign;
    }
    /**
     * 遍历类的变量
     * @param treeMap
     * @param object
     * @param cls
     * @param parseKeyFlag
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     */
    private static void getClassFields(TreeMap treeMap,Object object,Class<?>cls,boolean parseKeyFlag) throws IllegalArgumentException, IllegalAccessException{
        Field[] fields;
        DecimalFormat df = new DecimalFormat("######0.00");
        if(fieldMap.contains(cls.getName()) && fieldMap.get(cls.getName()) != null){
            fields = (Field[]) fieldMap.get(cls.getName());
        }else{
            fields = cls.getDeclaredFields();
            fieldMap.put(cls.getName(), fields);
        }
        for(Field field : fields){
            field.setAccessible(true);
            Object value = field.get(object);
            String name = field.getName();
            if(value instanceof Double){
                value = df.format(value);
            }
            if(value != null && name != "logger" && name != "sign"){
                if(value instanceof String && ((String)value).trim().length()==0)
                    continue;
                if(parseKeyFlag)
                    name = parseName(name);
                treeMap.put(name, value);
            }
        }
    }
    /**
     * 将大小写转换成下划线
     * @param name
     */
    public static String parseName(String name){
        StringBuffer result = new StringBuffer();
        for(int i=0 ;i<name.length();i++)
            if(Character.isUpperCase(name.charAt(i))){
                result.append("_"+Character.toLowerCase(name.charAt(i)));
            }else{
                result.append(name.charAt(i));
            }
        return result.toString();
    }
    /**
     * 生成带时间的唯一码
     * @param length
     * @return
     * @throws Exception
     */
    public static String createUniqueCode(int length) throws Exception{
        if(length<12)
            throw new Exception("长度不得小于12位");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Random random = new Random();
        StringBuffer sb = new StringBuffer(df.format(new Date()));
        length = length-sb.length();
        for(int i =0 ;i< length ; i++)
            sb.append(random.nextInt(10));
        return sb.toString();
    }
//    public static void main(String[] args) throws Exception {
//        PayPerson payPersonBean = new PayPerson(Constants.WX_APPID,Constants.WX_MCHID);
//        payPersonBean.setNonceStr(createUniqueCode(20));
//        payPersonBean.setPartnerTradeNo(createUniqueCode(26));
//        payPersonBean.setOpenid("oXl8GwVsF9eAccWoFpF38BMCe0pA");
//        payPersonBean.setCheckName("NO_CHECK");
//        payPersonBean.setAmount(1);
//        payPersonBean.setDesc("导购小程序转账测试");
//        payPersonBean.setSpbillCreateIp("192.168.0.1");
//        PayPersonReturn payPersonReturn = payPersion(payPersonBean);
//        System.out.println(payPersonReturn.toString());
//    }
}
